VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsSysTray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Esta clase es una versin reducida de la clase cSystray de "Cobein (www.advancevb.com.ar)" en http://www.planet-source-code.com/vb/scripts/ShowCode.asp?txtCodeId=68948&lngWId=1
'Se suprimio gran parte de codigo que era empleado en el SubClass
'Se suprimio el timer para ocultar el globo ya que en W7 parece desapaarcer este flag.
'Se suprimio la lectura del icono dentro de la clase.
'Alugnos cambios en lo personal.
'La idea fue reducir la clase y crear algo basico que funcione en XP, Vista, W7.
'No cuenta con las nuevas propiedades de W7, solo utiliza lo clasico.
'Copy & Paste by "Leandro Ascierto (www.leandroascierto.com.ar) el 17/06/2011.
Private Declare Sub CopyMemory Lib "KERNEL32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function SetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProcA Lib "user32" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function RegisterWindowMessage Lib "user32.dll" Alias "RegisterWindowMessageA" (ByVal lpString As String) As Long
Private Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function Shell_NotifyIcon Lib "shell32.dll" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, ByRef lpData As NOTIFYICONDATA) As Long
Private Declare Function FindWindow Lib "user32.dll" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Private Declare Function FindWindowEx Lib "user32.dll" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Private Declare Function DrawAnimatedRects Lib "user32" (ByVal hwnd As Long, ByVal idAni As Long, lprcFrom As RECT, lprcTo As RECT) As Long
Private Declare Function GetWindowRect Lib "user32.dll" (ByVal hwnd As Long, ByRef lpRect As RECT) As Long
Private Declare Function CopyIcon Lib "user32" (ByVal hIcon As Long) As Long
Private Declare Function DestroyIcon Lib "user32" (ByVal hIcon As Long) As Long


Private Type RECT
    Left    As Long
    Top     As Long
    Right   As Long
    Bottom  As Long
End Type

Private Type NOTIFYICONDATA
   cbSize                           As Long
   hwnd                             As Long
   uID                              As Long
   uFlags                           As Long
   uCallbackMessage                 As Long
   hIcon                            As Long
   szTip                            As String * 128
   dwState                          As Long
   dwStateMask                      As Long
   szInfo                           As String * 256
   uTimeout                         As Long
   szInfoTitle                      As String * 64
   dwInfoFlags                      As Long
End Type

Private Const GWL_WNDPROC           As Long = -4
Private Const TASKBARMESSAGE        As String = "TaskbarCreated"

'// Windows messages
Private Const WM_DESTROY            As Long = &H2
Private Const WM_MOUSEMOVE          As Long = &H200
Private Const WM_RBUTTONDBLCLK      As Long = &H206
Private Const WM_RBUTTONDOWN        As Long = &H204
Private Const WM_RBUTTONUP          As Long = &H205
Private Const WM_MBUTTONDBLCLK      As Long = &H209
Private Const WM_MBUTTONDOWN        As Long = &H207
Private Const WM_MBUTTONUP          As Long = &H208
Private Const WM_LBUTTONDBLCLK      As Long = &H203
Private Const WM_LBUTTONDOWN        As Long = &H201
Private Const WM_LBUTTONUP          As Long = &H202
Private Const WM_USER               As Long = &H400

'// Balloon messges
Private Const NIN_BALLOONSHOW       As Long = (WM_USER + 2)
Private Const NIN_BALLOONHIDE       As Long = (WM_USER + 3)
Private Const NIN_BALLOONTIMEOUT    As Long = (WM_USER + 4)
Private Const NIN_BALLOONUSERCLICK  As Long = (WM_USER + 5)

'// Tray update commands
Private Const NIM_ADD               As Long = &H0
Private Const NIM_DELETE            As Long = &H2
Private Const NIM_MODIFY            As Long = &H1

'// Tray update masks
Private Const NIF_ICON              As Long = &H2
Private Const NIF_INFO              As Long = &H10
Private Const NIF_MESSAGE           As Long = &H1
Private Const NIF_STATE             As Long = &H8
Private Const NIF_TIP               As Long = &H4

'// DrawAnimatedRects
Private Const IDANI_OPEN            As Long = &H1
Private Const IDANI_CLOSE           As Long = &H2
Private Const IDANI_CAPTION         As Long = &H3

Public Enum ttIconType
    TTNoIcon = 0
    TTIconInfo = 1
    TTIconWarning = 2
    TTIconError = 3
    TTIconUser = 4
End Enum

Public Event MouseMove()
Public Event MouseDown(Button As Integer)
Public Event MouseUp(Button As Integer)
Public Event MouseDblClick(Button As Integer)
Public Event BalloonClose()
Public Event BalloonClick()
Public Event BalloonShow()
Public Event BalloonHide()
 
Private PrevWndProc         As Long
Private bvASM(40)           As Byte
Private m_hwnd              As Long
Private WM_TASKBARMESSAGE   As Long
Private tNID                As NOTIFYICONDATA
Private m_ToolTip           As String
Private m_hIcon             As Long
Private m_BalloonTitle      As String
Private m_BalloonText       As String
Private m_BalloonIconType   As ttIconType
Private IsIconVisible       As Boolean

Public Function WindowProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

    WindowProc = CallWindowProcA(PrevWndProc, hwnd, uMsg, wParam, lParam)
 
    If uMsg = WM_DESTROY Then
        Call StopSubclassing(hwnd)
    ElseIf uMsg = WM_MOUSEMOVE Then
        
        Select Case lParam
            Case WM_LBUTTONDBLCLK:              RaiseEvent MouseDblClick(vbLeftButton)
            Case WM_LBUTTONDOWN:                RaiseEvent MouseDown(vbLeftButton)
            Case WM_LBUTTONUP:                  RaiseEvent MouseUp(vbLeftButton)
            Case WM_MBUTTONDBLCLK:              RaiseEvent MouseDblClick(vbMiddleButton)
            Case WM_MBUTTONDOWN:                RaiseEvent MouseDown(vbMiddleButton)
            Case WM_MBUTTONUP:                  RaiseEvent MouseUp(vbMiddleButton)
            Case WM_RBUTTONDBLCLK:              RaiseEvent MouseDblClick(vbRightButton)
            Case WM_RBUTTONDOWN:                RaiseEvent MouseDown(vbRightButton)
            Case WM_RBUTTONUP:                  RaiseEvent MouseUp(vbRightButton)
            Case WM_MOUSEMOVE:                  RaiseEvent MouseMove
            Case NIN_BALLOONUSERCLICK:          RaiseEvent BalloonClick
            Case NIN_BALLOONTIMEOUT:            RaiseEvent BalloonClose
            Case NIN_BALLOONSHOW:               RaiseEvent BalloonShow
            Case NIN_BALLOONHIDE:               RaiseEvent BalloonHide
        End Select
    ElseIf uMsg = WM_TASKBARMESSAGE Then
        If IsIconVisible Then
            IsIconVisible = False
            SysTrayShow True
        End If
    End If
    
End Function
 
Private Sub SetSubclassing(Obj As Object, hwnd As Long)
    Dim WindowProcAddress As Long
    Dim pObj As Long
    Dim pVar As Long
 
    Dim i As Long
 
    For i = 0 To 40
        bvASM(i) = Choose(i + 1, &H55, &H8B, &HEC, &H83, &HC4, &HFC, &H8D, &H45, &HFC, &H50, &HFF, &H75, &H14, _
                                 &HFF, &H75, &H10, &HFF, &H75, &HC, &HFF, &H75, &H8, &H68, &H0, &H0, &H0, &H0, _
                                 &HB8, &H0, &H0, &H0, &H0, &HFF, &HD0, &H8B, &H45, &HFC, &HC9, &HC2, &H10, &H0)
    Next i
 
    pObj = ObjPtr(Obj)
 
    Call CopyMemory(pVar, ByVal pObj, 4)
    'Call CopyMemory(WindowProcAddress, ByVal (pVar + &H1C + (ProcIndex * 4&)), 4)
    Call CopyMemory(WindowProcAddress, ByVal (pVar + 28), 4)
 
    Call LongToByte(pObj, bvASM, 23)
    Call LongToByte(WindowProcAddress, bvASM, 28)
 
    PrevWndProc = SetWindowLongA(hwnd, GWL_WNDPROC, VarPtr(bvASM(0)))
End Sub
 
Private Sub StopSubclassing(hwnd)
    If PrevWndProc Then
        Call SetWindowLongA(hwnd, GWL_WNDPROC, PrevWndProc)
        PrevWndProc = 0
    End If
End Sub
 
Private Sub LongToByte(ByVal lLong As Long, ByRef bReturn() As Byte, Optional i As Integer = 0)
    bReturn(i) = lLong And &HFF
    bReturn(i + 1) = (lLong And 65280) / &H100
    bReturn(i + 2) = (lLong And &HFF0000) / &H10000
    bReturn(i + 3) = ((lLong And &HFF000000) \ &H1000000) And &HFF
End Sub

Private Sub Class_Initialize()

    WM_TASKBARMESSAGE = RegisterWindowMessage(TASKBARMESSAGE)
    m_hwnd = CreateWindowEx(0, "STATIC", vbNullString, 0, 0, 0, 0, 0, 0, 0, App.hInstance, 0)
    
    With tNID
        .cbSize = Len(tNID)
        .hwnd = m_hwnd
        .uID = ObjPtr(Me)
        .uCallbackMessage = WM_MOUSEMOVE
    End With
    
    Call SetSubclassing(Me, m_hwnd)
End Sub

Private Sub Class_Terminate()
    Me.SysTrayShow False
    Call StopSubclassing(m_hwnd)
    Call DestroyWindow(m_hwnd)
    If m_hIcon Then Call DestroyIcon(m_hIcon)
End Sub

Public Property Get ToolTip() As String
    ToolTip = m_ToolTip
End Property

Public Property Let ToolTip(ByVal New_ToolTip As String)
    m_ToolTip = Trim$(New_ToolTip)
    If IsIconVisible Then
        With tNID
            .uFlags = NIF_TIP
            .szTip = m_ToolTip & vbNullChar
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Property

Public Property Get Icon() As Long
    Icon = m_hIcon
End Property

Public Property Let Icon(ByVal New_Icon As Long)
    If m_hIcon Then Call DestroyIcon(m_hIcon)
    m_hIcon = CopyIcon(New_Icon)
    If IsIconVisible Then
        With tNID
            .uFlags = NIF_ICON
            .hIcon = m_hIcon
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Property

Public Sub SysTrayShow(Optional ByVal bShow As Boolean = True)
    If bShow Then
        If Not IsIconVisible Then
            With tNID
                .uFlags = NIF_MESSAGE
                .uCallbackMessage = WM_MOUSEMOVE
                         
                If m_hIcon Then
                    .uFlags = .uFlags Or NIF_ICON
                    .hIcon = m_hIcon
                End If
                    
                If Len(m_ToolTip) Then
                    .uFlags = .uFlags Or NIF_TIP
                    .szTip = m_ToolTip & vbNullChar
                End If
            End With
            
            Shell_NotifyIcon NIM_ADD, tNID
            IsIconVisible = True
        End If
    Else
        If IsIconVisible Then
            Shell_NotifyIcon NIM_DELETE, tNID
            IsIconVisible = False
        End If
    End If
End Sub

Public Property Get BalloonIcon() As ttIconType
    BalloonIcon = m_BalloonIconType
End Property

Public Property Let BalloonIcon(ByVal IconType As ttIconType)

    m_BalloonIconType = IconType
    
    If IsIconVisible Then
        With tNID
            .uFlags = NIF_INFO Or NIF_TIP
            .dwInfoFlags = m_BalloonIconType
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Property

Public Property Get BalloonTitle() As String
    BalloonTitle = m_BalloonTitle
End Property

Public Property Let BalloonTitle(ByVal sTitle As String)
    m_BalloonTitle = sTitle
    If IsIconVisible Then
        With tNID
            .uFlags = NIF_INFO Or NIF_TIP
            .szInfoTitle = m_BalloonTitle & vbNullChar
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Property

Public Property Get BalloonText() As String
    BalloonText = m_BalloonText
End Property

Public Property Let BalloonText(ByVal sText As String)
    m_BalloonText = sText
    If IsIconVisible Then
        With tNID
            .uFlags = NIF_INFO Or NIF_TIP
            .szInfo = m_BalloonText & vbNullChar
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Property

Public Sub BalloonShow(Optional ByVal bShow As Boolean = True)
    If bShow Then
        If IsIconVisible Then
            BalloonShow False
            With tNID
                .uFlags = NIF_INFO
                .szInfo = m_BalloonText & vbNullChar
                .szInfoTitle = BalloonTitle & vbNullChar
                .dwInfoFlags = m_BalloonIconType
            End With
            Shell_NotifyIcon NIM_MODIFY, tNID
        End If
    Else
        With tNID
            .uFlags = NIF_INFO
            .szInfo = vbNullChar
            .szInfoTitle = vbNullChar
        End With
        Shell_NotifyIcon NIM_MODIFY, tNID
    End If
End Sub

Public Sub BeforePopup()
    Call SetForegroundWindow(m_hwnd)
End Sub

'Not available for Window Vista or Seven with Aero theme enabled
Public Sub ShowMinimzeToSysTray(ByVal hwnd As Long)
    Dim rSource As RECT, rDest As RECT
    GetWindowRect hwnd, rSource
    GetWindowRect FindWindowEx(FindWindow("Shell_TrayWnd", vbNullString), 0, "TrayNotifyWnd", vbNullString), rDest
    Call DrawAnimatedRects(hwnd, IDANI_CLOSE Or IDANI_CAPTION, rSource, rDest)
End Sub

'Not available for Window Vista or Seven with Aero theme enabled
Public Sub ShowRestoreFromSysTray(ByVal hwnd As Long)
    Dim rSource As RECT, rDest As RECT
    GetWindowRect FindWindowEx(FindWindow("Shell_TrayWnd", vbNullString), 0, "TrayNotifyWnd", vbNullString), rSource
    GetWindowRect hwnd, rDest
    Call DrawAnimatedRects(hwnd, IDANI_OPEN Or IDANI_CAPTION, rSource, rDest)
End Sub

